#!/bin/bash

lic_detec()
{
licType=UnKnowen
dirSysam=`timeout 10 find / -name "SYSAM-*"`
licDir=$dirSysam/licenses
licFile=`grep -l VERINT $licDir/*`
[ "X$licFile" != "X" ] && licType=`grep PACKAGE $licFile | awk '{print $2}'| awk -F'_' '{print $2}'`
ver=`echo $licType`
name="Sybase license type"
}

system_params()
{
hostName=`/bin/hostname`
echo "  <ParamsTable>"
echo "          <SectionName>Network</SectionName>"
echo "          <ParamName>Computer Name</ParamName>"
echo "          <Value>$hostName</Value>"
echo "  </ParamsTable>"

macAddress=`/sbin/ifconfig | /bin/grep eth0 | /bin/awk '{print $NF}'`
echo "  <ParamsTable>"
echo "          <SectionName>NIC1</SectionName>"
echo "          <ParamName>MAC Address</ParamName>"
echo "          <Value>$macAddress</Value>"
echo "  </ParamsTable>"
echo "  <ParamsTable>"
echo "          <SectionName>Network</SectionName>"
echo "          <ParamName>Number of NIC's</ParamName>"
echo "          <Value>1</Value>"
echo "  </ParamsTable>"

kernelVersion=`/bin/cat /proc/version | /bin/cut -d"(" -f1`
echo "  <ParamsTable>"
echo "          <SectionName>Operating System</SectionName>"
echo "          <ParamName>Kernel Version</ParamName>"
echo "          <Value>$kernelVersion</Value>"
echo "  </ParamsTable>"

OSversion=`/bin/cat /proc/version | /bin/cut -d"(" -f4 | /bin/cut -d")" -f1`
echo "  <ParamsTable>"
echo "          <SectionName>Operating System</SectionName>"
echo "          <ParamName>OS Version</ParamName>"
echo "          <Value>$OSversion</Value>"
echo "  </ParamsTable>"

slashMountPoint=`/bin/df -k / | /usr/bin/tail -1 | /bin/awk '{print $1}'`
UUID=`/sbin/tune2fs -l $slashMountPoint | /bin/grep "Filesystem UUID" | /bin/awk '{print $NF}'`
echo "  <ParamsTable>"
echo "          <SectionName>HW</SectionName>"
echo "          <ParamName>Universal Uniqe ID</ParamName>"
echo "          <Value>$UUID</Value>"
echo "  </ParamsTable>"

numberCPU=`nproc`
echo "  <ParamsTable>"
echo "          <SectionName>HW</SectionName>"
echo "          <ParamName>Logical CPU's</ParamName>"
echo "          <Value>$numberCPU</Value>"
echo "  </ParamsTable>"

totalMemory=`free -m | grep Mem: | awk '{print $2}'`
echo "  <ParamsTable>"
echo "          <SectionName>HW</SectionName>"
echo "          <ParamName>Total Physical Memory</ParamName>"
echo "          <Value>$totalMemory</Value>"
echo "  </ParamsTable>"

machineModel=`/usr/sbin/dmidecode | /bin/grep -i "Product Name" | /bin/awk '{print $3" "$4" "$5}'`
echo "  <ParamsTable>"
echo "          <SectionName>OtherHW</SectionName>"
echo "          <ParamName>Computer Model</ParamName>"
echo "          <Value>$machineModel</Value>"
echo "  </ParamsTable>"

savVersion=`/opt/Symantec/symantec_antivirus/sav info -p`
echo "  <ParamsTable>"
echo "          <SectionName>AntiVirus</SectionName>"
echo "          <ParamName>Symantec AntiVirus</ParamName>"
echo "          <Value>$savVersion</Value>"
echo "  </ParamsTable>"

savEngineVersion=`/opt/Symantec/symantec_antivirus/sav info -e`
echo "  <ParamsTable>"
echo "          <SectionName>AntiVirus</SectionName>"
echo "          <ParamName>Engine Version</ParamName>"
echo "          <Value>$savEngineVersion</Value>"
echo "  </ParamsTable>"

savVDAD=`export LC_TIME="en_US.UTF-8"; /opt/Symantec/symantec_antivirus/sav info -d`
echo "  <ParamsTable>"
echo "          <SectionName>AntiVirus</SectionName>"
echo "          <ParamName>Virus Definition And Date</ParamName>"
echo "          <Value>$savVDAD</Value>"
echo "  </ParamsTable>"

autoProtectStatus=`/opt/Symantec/symantec_antivirus/sav info -a`
echo "  <ParamsTable>"
echo "          <SectionName>AntiVirus</SectionName>"
echo "          <ParamName>Auto Protect Status</ParamName>"
echo "          <Value>$autoProtectStatus</Value>"
echo "  </ParamsTable>"

lastScanDate=`/bin/ls -ltr /var/symantec/Logs/ | /usr/bin/tail -1 | /bin/awk '{print $6" "$7" "$8}'`
echo "  <ParamsTable>"
echo "          <SectionName>AntiVirus</SectionName>"
echo "          <ParamName>Last Scan Date</ParamName>"
echo "          <Value>$lastScanDate</Value>"
echo "  </ParamsTable>"

lastScanLog=`/bin/ls -ltr /var/symantec/Logs/ | /usr/bin/tail -1 | /bin/awk '{print $NF}'`
lastScanResults=`/bin/cat /var/symantec/Logs/$lastScanLog | /bin/grep "Scan Complete" | /bin/awk '{print $3" "$4}'`
numOfThreats=`/bin/echo $lastScanResults | /bin/awk '{print $2}'`
echo "  <ParamsTable>"
echo "          <SectionName>AntiVirus</SectionName>"
echo "          <ParamName>Last Scan Results</ParamName>"
echo "          <Value>$numOfThreats</Value>"
echo "  </ParamsTable>"


rpm -qa --queryformat '%{NAME} %{VERSION}\n' |  awk ' 
{ print "<ParamsTable>" }
{ print "          <SectionName>Applications</SectionName>"}
{ print "          <ParamName>" $1 "</ParamName>"}
{ print "          <Value>" $2 "</Value>"}
{ print "</ParamsTable>"}
 '
}

verDir=/script/VERSIONS

echo "<?xml version=\"1.0\" standalone=\"yes\"?>"
echo "<ExtractedParamsDS  xmlns=\"http://tempuri.org/ExtractedParamsDS.xsd\">"
l=`ls -d $verDir/VER_*`
for list in `echo lic $l`
do
        if [ $list = lic ]; then
                lic_detec
        else
                ver=`echo $list | awk -F'_' '{print $NF}'`
                name=`echo $list | sed -e "s!$verDir/VER_!!" -e "s/_$ver//"`
        fi
        echo "  <ParamsTable>"
        echo "          <SectionName>Applications</SectionName>"
        echo "          <ParamName>$name</ParamName>"
        echo "          <Value>$ver</Value>"
        echo "  </ParamsTable>"
done
system_params

echo "</ExtractedParamsDS>"
